"""Implements an object capable of controlling the channel list page.

Classes:
    ChannelPlayerPage: A representation of the channel player page.
"""

from fwk.base.locators import ByClass
from fwk.base.locators import ByCss
from .channel_page import ChannelPage


class PlayerPage(ChannelPage):
    """A utility class that can manipulate channel player page for tests."""

    #  Elements definition
    PLAYER = ByClass('player')
    PLAYER_BUTTON = ByClass('js-control-play-button')
    PLAYER_FRAME = ByCss('iframe')

    def switch_to_player_frame(self):
        """Switch control to the player iframe on the page."""
        self.wait_for_visible(self.PLAYER_FRAME, 5)
        player_frame = self.driver.find_element_by_css_selector('iframe')
        self.driver.switch_to.frame(player_frame)

    def switch_to_parent_frame(self):
        """Switch control back to the main page."""
        self.driver.switch_to.default_content()

    def is_player_loaded(self):
        """Return a bool describing whether or not the player is loaded."""
        return self.driver.find_element(*self.PLAYER).is_displayed()

    def play(self):
        """Click on the play button if the button is currently displayed."""
        if self.is_player_icon_displayed():
            self.driver.find_element(*self.PLAYER_BUTTON).click()

    def is_player_icon_displayed(self):
        """Return a bool if the play button on the player screen is present."""
        return self.wait_for_visible(self.PLAYER_BUTTON)
