"""Contains all UX tests for the channel directory page."""

from math import floor
import pytest
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.directory_page import DirectoryPage


USED_GAME_NAME = 'League of Legends'
GAME_URL = '/directory/game/League%20of%20Legends'


@pytest.fixture(scope='function', autouse=True)
def channel_directory_page(driver):
    """Return a DirectoryPage object."""
    channel_directory_page = DirectoryPage(driver)
    channel_directory_page.open(GAME_URL)
    return channel_directory_page


def test_channel_directory(channel_directory_page):
    """Verify that channel directory has proper ui elements."""
    # Verify that nav bar is visible.
    soft_assert = DelayedAssertion()
    soft_assert.expect(channel_directory_page.is_nav_bar_displayed())
    # Verify that 1 game thumbnail per row is displayed.
    soft_assert.expect(floor(channel_directory_page.channels_per_row()) == 1)

    # Verify that the channel screenshot is displayed & has valid data.
    soft_assert.expect(channel_directory_page.is_box_art_displayed())
    # Check game name
    soft_assert.expect(USED_GAME_NAME in channel_directory_page.game_name())
    # Check viewers' count
    soft_assert.expect(channel_directory_page.is_viewers_count_displayed())
    soft_assert.expect(channel_directory_page.viewers_count() > 0)
    # Check Card title not to be empty
    soft_assert.expect(channel_directory_page.is_card_title_displayed())
    soft_assert.expect(channel_directory_page.card_title())

    # Verify that more channels populate when scrolled down.
    old_channels = channel_directory_page.all_channels_name()
    channel_directory_page.scroll_screen('down')
    new_channels = channel_directory_page.all_channels_name()
    soft_assert.expect(new_channels != old_channels)

    soft_assert.assert_expectations()


def test_channel_page_through_channel_directory(channel_directory_page):
    """Verify that user can navigate to channel page via channel directory."""
    channel_directory_page.click_on_channel()
    assert channel_directory_page.is_on_channel_page()
