"""Contains all UX tests for the channel page."""
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.player_page import PlayerPage

CHANNEL = 'Monstercat'
CHAT_MESSAGE = 'Welcome to the chat room!'
DESKTOP_MODE = 'Switch to Desktop Mode'
HOSTING_MESSAGE = 'qa_auto_host\nhosting Monstercat'


def test_channel_page_ui(driver):
    """ChannelPage object to a live channel."""
    soft_assert = DelayedAssertion()
    channel_page = PlayerPage(driver)
    channel_page.open('/monstercat')
    soft_assert.expect(channel_page.is_logo_present())
    soft_assert.expect(channel_page.is_channel_metadata_present())
    soft_assert.expect(CHANNEL in channel_page.channel_metadata_text())
    soft_assert.expect(channel_page.is_chat_pane_present())
    soft_assert.expect(CHAT_MESSAGE in channel_page.chat_status_text())
    soft_assert.expect(channel_page.is_top_nav_displayed())
    channel_page.click_nav_icon()
    soft_assert.expect(DESKTOP_MODE in channel_page.nav_menu_contents())
    channel_page.click_nav_icon()
    channel_page.switch_to_player_frame()
    soft_assert.expect(channel_page.is_player_loaded())
    channel_page.play()
    soft_assert.expect(channel_page.is_player_icon_displayed() is False)
    channel_page.switch_to_parent_frame()
    soft_assert.expect(channel_page.is_top_nav_displayed())
    channel_page.click_nav_icon()
    soft_assert.expect(DESKTOP_MODE in channel_page.nav_menu_contents())
    channel_page.open('/qa_auto_host')
    channel_page.is_online_channel_loaded('/qa_auto_host')
    soft_assert.expect(HOSTING_MESSAGE in channel_page.channel_metadata_text())
    soft_assert.assert_expectations()
