"""Events page scenarios."""
import re
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.events_page import EventsPage


EVENT_DESCRIPTION = """Tune in to learn about new Twitch features, \
discover awesome streams and streamers, and hang out with hosts \
djWHEAT, AnnaProsser, Atrioc, and FishStix on this weekly talk \
show for the Twitch community.\n\nStay tuned after for a Q&A with \
Ann Druyan (Co-Creator of COSMOS)"""
SHARE_ITEM_LIST = ['Twitter', 'Reddit', 'Facebook', 'Copy']


def test_events_page_ui(driver):
    """Test events page UI."""
    events_page = EventsPage(driver)
    soft_assert = DelayedAssertion()
    events_page.open('/events/39623')
    # Verify that events page has calendar widget with month and date.
    soft_assert.expect(events_page.is_month_displayed())
    soft_assert.expect(events_page.is_day_displayed())
    # Verify that events page title is Twitch Weekly - Twitch.
    soft_assert.expect(events_page.driver.title == 'Twitch Weekly - Twitch')
    # Verify that event channel has twitch channel with logo.
    soft_assert.expect(events_page.is_channel_with_logo_present())
    # Verify that event channel has talk shows game with logo.
    soft_assert.expect(events_page.is_game_with_logo_present())
    # Verify that event page has event description.
    soft_assert.expect(EVENT_DESCRIPTION ==
                       events_page.event_description_text())
    # Verify that event page has correct timestamp format of the event.
    re1 = '((?:Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday))'
    re2 = '(,)'
    re3 = '(\\s+)'
    re4 = '((?:Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May|Jun(?:e)?))'
    re5 = '(\\d+)'
    re6_1 = '((?:(?:[0-1][0-9])|(?:[2][0-3])|(?:[0-9])):'
    re6_2 = '(?:[0-5][0-9])(?::[0-5][0-9])?(?:\\s?(?:AM|PM))?)'
    re6 = re6_1 + re6_2
    re7 = '(-)'

    rg = re.compile(re1 + re2 + re3 + re4 + re3 + re5 + re3 +
                    re6 + re3 + re7 + re3 + re6, re.IGNORECASE | re.DOTALL)
    if rg.search(events_page.timestamp_on_events_page()):
        soft_assert.expect(True)
    else:
        soft_assert.expect(False)
    # Verify that event page has share buttons with social media options.
    events_page.expand_share_options()
    soft_assert.expect(events_page.share_dock_item_list() == SHARE_ITEM_LIST)
    soft_assert.assert_expectations()
