"""Contains scenarios for games directory page."""

import pytest
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.directory_page import DirectoryPage
from .pages.enums.screen_mode import ScreenMode


@pytest.fixture(scope='function', autouse=True)
def games_directory_page(driver):
    """Return a DirectoryPage object."""
    games_directory_page = DirectoryPage(driver)
    games_directory_page.open('/')
    return games_directory_page


def test_games_directory_ui(games_directory_page):
    """Test that expected elements are available on games directory page."""
    soft_assert = DelayedAssertion()
    soft_assert.expect(games_directory_page.is_game_list_present())
    soft_assert.expect(games_directory_page.is_nav_bar_displayed())
    soft_assert.expect(games_directory_page.is_box_art_displayed())
    soft_assert.expect(games_directory_page.is_card_title_displayed())

    # Test displayed games count per row.
    # 2 games per row when in PORTRAIT
    # 4 games per row in LANDSCAPE mode
    soft_assert.expect(games_directory_page.cards_per_row() == 2)
    games_directory_page.rotate_screen(ScreenMode.LANDSCAPE.value)
    soft_assert.expect(games_directory_page.cards_per_row() == 4)
    games_directory_page.rotate_screen(ScreenMode.PORTRAIT.value)
    # Click on the first game to verify the channel list
    games_directory_page.click_first_game()
    soft_assert.expect(games_directory_page.is_channel_list_present())
    soft_assert.assert_expectations()
