"""Test for Ltv to Live scenarios."""
import os
import pytest
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.player_page import PlayerPage


CHANNEL = 'Monstercat'
CHAT_MESSAGE = 'Welcome to the chat room!'
PLAYING_FIELD = 'Playing Music'
STREAM_URL = '/streams/26461201120/channel/27446517'


@pytest.fixture
def _channel_page(driver):
    """Fixture for all test cases below."""
    _channel_page = PlayerPage(driver)
    _channel_page.open(STREAM_URL)
    return _channel_page


@pytest.mark.skipif(os.getenv('env') != "prod",
                    reason="Feature not supported on localserver")
def test_user_goes_to_LTV_link(_channel_page):
    """Verify content on channel page."""
    soft_assert = DelayedAssertion()
    soft_assert.expect(_channel_page.is_top_nav_displayed())
    soft_assert.expect(_channel_page.is_twitch_logo_present())
    soft_assert.expect(_channel_page.is_channel_metadata_present())
    soft_assert.expect(CHANNEL in _channel_page.channel_metadata_text())
    soft_assert.expect(PLAYING_FIELD in _channel_page.channel_metadata_text())
    soft_assert.expect(CHAT_MESSAGE in _channel_page.chat_status_text())
    # Verify the stream starts playing.
    _channel_page.switch_to_player_frame()
    soft_assert.expect(_channel_page.is_player_loaded())
    _channel_page.play()
    soft_assert.expect(not _channel_page.is_player_icon_displayed())
    _channel_page.switch_to_parent_frame()
    soft_assert.assert_expectations()
