"""Test for live to vod scenarios."""
import os
import pytest
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.player_page import PlayerPage


CHANNEL = 'Monstercat'
BROWSE_CHANNEL_TEXT = 'Browse all other channels!'
BROWSE_GAMES_TEXT = 'Browse all other games!'
SWITCH_DESKTOP_MODE = 'Switch to Desktop Mode'
VOD_URL = '/streams/13842044576/channel/27446517'


@pytest.fixture
def _channel_page(driver):
    """Driver Initialization for channel page."""
    _channel_page = PlayerPage(driver)
    _channel_page.open(VOD_URL)
    return _channel_page


@pytest.mark.skipif(os.getenv('env') != "prod",
                    reason="Feature not supported on localserver")
def test_when_user_goes_to_Vod_LTV_link(_channel_page):
    """Verify content on channel page."""
    soft_assert = DelayedAssertion()
    soft_assert.expect(_channel_page.is_top_nav_displayed())
    soft_assert.expect(_channel_page.is_channel_metadata_present())
    soft_assert.expect(CHANNEL in _channel_page.channel_metadata_text())
    soft_assert.expect(_channel_page.channel_metadata_text() is not None)
    soft_assert.expect(_channel_page.is_twitch_logo_present())
    soft_assert.expect(_channel_page.is_browse_all_gmaes_btn_present())
    soft_assert.expect(BROWSE_GAMES_TEXT in _channel_page.
                       browse_all_games_btn_label())
    soft_assert.expect(_channel_page.is_browse_all_gmaes_btn_present())
    soft_assert.expect(BROWSE_GAMES_TEXT in _channel_page.
                       browse_all_games_btn_label())
    soft_assert.expect(_channel_page.is_switch_to_desktop_btn_present())
    soft_assert.expect(SWITCH_DESKTOP_MODE in _channel_page.
                       switch_to_desktop_btn_label())
    # Verify player is loaded and video start playing.
    _channel_page.switch_to_player_frame()
    soft_assert.expect(_channel_page.is_player_loaded())
    _channel_page.play()
    soft_assert.expect(not _channel_page.is_player_icon_displayed())
    _channel_page.switch_to_parent_frame()
    soft_assert.assert_expectations()
