"""Contains all UX tests for the profile page."""
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.profile_page import ProfilePage

OFFLINE_CHANNEL = 'qa_auto_offline'


def test_offline_channel_page_ui(driver):
    """Test offline channel page UI."""
    soft_assert = DelayedAssertion()
    profile_page = ProfilePage(driver)
    profile_page.open('/' + OFFLINE_CHANNEL)
    soft_assert.expect(profile_page.is_profile_page(OFFLINE_CHANNEL))
    soft_assert.expect(profile_page.is_top_nav_displayed())
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_EXPAND_BUTTON))
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_AVATAR))
    profile_page.click_profile_expand_btn()
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_CLOSE_BUTTON))
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_DESCRIPTION))
    soft_assert.expect(profile_page.is_past_broadcast_card_displayed()
                       is False)
    soft_assert.assert_expectations()
