"""Verify Profile page for online channel."""
import pytest
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.profile_page import ProfilePage

LIVE_STATUS = 'LIVE'
STREAM_URL = '/monstercat/profile'
ARRAY_OF_HEADERS = ["Monstercat's Recent Highlights", "Monstercat's Top Clips",
                    "Monstercat's Recent Videos"]
FOOD_URL = '/food/profile'
HEADER = 'Now Streaming'
PROFILE = 'profile'
CHANNEL_NAME = '/monstercat'
STREAM_URL = '/monstercat/profile'
CLIPS = 'Clips'
HIGHLIGHTS = 'Highlights'


@pytest.fixture
def profile_page(driver):
    """Return a ProfilePage object to a live channel."""
    profile_page = ProfilePage(driver)
    profile_page.open(STREAM_URL)
    return profile_page


def test_channel_profile_page_content(profile_page):
    """Verify channel page content."""
    soft_assert = DelayedAssertion()
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_RED_INDICATOR))
    soft_assert.expect(LIVE_STATUS in profile_page.profile_indicator_status())
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_EXPAND_BUTTON))
    soft_assert.expect(profile_page.is_profile_followers_count_present())
    soft_assert.expect(profile_page.is_profile_viewers_count_present())
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_AVATAR))
    profile_page.click_profile_expand_btn()
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_CLOSE_BUTTON))
    soft_assert.expect(profile_page.is_displayed
                       (profile_page.PROFILE_DESCRIPTION))
    soft_assert.expect(profile_page.header_text().sort() ==
                       ARRAY_OF_HEADERS.sort())
    soft_assert.expect(not profile_page.broadcast_present())
    soft_assert.assert_expectations()


def test_verify_video_cards_content(profile_page):
    """Entry should have thumbnail, runtime and title, game on left."""
    soft_assert = DelayedAssertion()
    clips = profile_page.section_on_page(CLIPS)
    soft_assert.expect(clips is not None)
    soft_assert.expect(len(profile_page.video_cards(CLIPS)) == 3)
    soft_assert.expect(profile_page.entity_details(CLIPS))

    highlights = profile_page.section_on_page(HIGHLIGHTS)
    soft_assert.expect(highlights is not None)
    soft_assert.expect(len(profile_page.video_cards(HIGHLIGHTS)) == 3)
    soft_assert.expect(profile_page.entity_details(HIGHLIGHTS))

    profile_page.click_show_more_button(CLIPS)
    soft_assert.expect(len(profile_page.video_cards(CLIPS)) == 6)

    profile_page.click_show_more_button(HIGHLIGHTS)
    soft_assert.expect(len(profile_page.video_cards(HIGHLIGHTS)) == 6)
    soft_assert.assert_expectations()


def test_food_page_profile_content(profile_page):
    """Verify Most recent broadcast header."""
    soft_assert = DelayedAssertion()
    profile_page.open(FOOD_URL)
    soft_assert.expect(profile_page.channel_header_text() == HEADER)
    soft_assert.expect(profile_page.food_page_profile_content())
    soft_assert.expect(profile_page.play_button())
    soft_assert.assert_expectations()


def test_url_does_not_redirects_to_profile_page(profile_page):
    """Verify url not redirects to profile page."""
    profile_page.open(CHANNEL_NAME)
    assert not profile_page.is_profile_page(CHANNEL_NAME)
