"""Upsell page scenarios."""
from fwk.base.delayed_assertion import DelayedAssertion

from .pages.upsell_page import UpsellPage

UPSELL_PITCH_TEXT = 'Watch and chat with your favorite broadcasters.'
SITE_WWW_URL = 'https://www.twitch.tv/upsell/me?no-mobile-redirect=true'


def test_upsell_page_ui(driver):
    """Test scenarios for Upsell Page."""
    # Initiate driver for upsell page
    soft_assert = DelayedAssertion()
    upsell_page = UpsellPage(driver)
    upsell_page.open('/upsell/me')
    # Verify the current page is upsell page with pitch text and twitch logo.
    soft_assert.expect(upsell_page.is_upsell_page())
    soft_assert.expect(upsell_page.upsell_pitch_text() == UPSELL_PITCH_TEXT)
    soft_assert.expect(upsell_page.is_twitch_logo_present())
    # Verify upsell page has Open in App link with correct href.
    soft_assert.expect(upsell_page.is_open_in_app_present())
    soft_assert.expect(upsell_page.is_open_in_app_button_link_correct())
    # Verify correct URL is loaded after switch to desktop
    upsell_page.open('/upsell/me')
    soft_assert.expect(upsell_page.is_switch_to_desktop_mode_link_displayed())
    upsell_page.switch_to_desktop()
    soft_assert.expect(upsell_page.url_after_switch_to_desktop() ==
                       SITE_WWW_URL)
    soft_assert.assert_expectations()
