// Unceremoniously lifted & extended from player_ui.
module.exports = {
  parserOptions: {
    ecmaVersion: 6,
    sourceType: 'module',
  },
  rules: {
    indent: ['error', 2],
    quotes: [2, 'single'],
    'no-var': 0,
    semi: [2, 'always'],
    'comma-dangle': [2, 'always-multiline'],
    eqeqeq: 2,
    // this rule incorrectly identifies some `let` vars as requiring `const`;
    // consider re-enabling after the antipattern style (functions beginning
    // with `var self = this;` are fully refactored.
    'prefer-const': 2,
    'object-shorthand': [2, 'methods'],
    'quote-props': [2, 'as-needed'],
    'max-len': [2, 120],
    'no-loop-func': 2,
    'no-param-reassign': [2, { props: true }],
    'arrow-spacing': 2,
    'arrow-parens': [2, 'as-needed'],
    'no-trailing-spaces': 2,
    'no-nested-ternary': 2,
    'brace-style': [2, '1tbs'],
    'space-before-blocks': 2,
    'space-infix-ops': 2,
    'space-in-parens': [2, 'never'],
    'array-bracket-spacing': [2, 'never'],
    'object-curly-spacing': [2, 'always'],
    'comma-style': [2, 'last'],
    camelcase: [2, { properties: 'always' }],
    'new-cap': 2,
    'prefer-template': 2,
    'dot-notation': 2,
    'one-var': [2, 'never'],
    'no-unused-vars': 2,
    'no-console': 0,
    'eol-last': 2,
    'no-multiple-empty-lines': [2, { max: 1 }],
    'keyword-spacing': 2,
  },
  env: {
    es6: true,
    node: true,
  },
  globals: {
    require: true,
  },
  extends: 'eslint:recommended',
};
