'use strict';

const webpack = require('webpack');
const webpackMerge = require('webpack-merge');
const StyleExtHtmlWebpackPlugin = require('style-ext-html-webpack-plugin');

const baseClientConfig = require('./webpack.client.base');

module.exports = webpackMerge(baseClientConfig, {
  entry: {
    index: [
      'react-hot-loader/patch',
      'webpack-hot-middleware/client?path=/__webpack_hmr&timeout=20000&reload=true',
      './src/client/index',
    ],
  },
  plugins: [
    new StyleExtHtmlWebpackPlugin({
      position: 'head-bottom',
      chunks: ['index', 'upsell', 'chatEmbed'],
      minify: true,
    }),
    new webpack.HotModuleReplacementPlugin(),
    new webpack.NoEmitOnErrorsPlugin(),
  ],
});
