'use strict';

const webpack = require('webpack');
const webpackMerge = require('webpack-merge');
const StyleExtHtmlWebpackPlugin = require('style-ext-html-webpack-plugin');

const baseClientConfig = require('./webpack.client.base');

module.exports = webpackMerge.smart(baseClientConfig, {
  output: {
    filename: 'bundle-[name].[hash].js',
  },
  module: {
    rules: [
      {
        test: /chatWorker\.js/,
        use: {
          loader: 'worker-loader',
          options: {
            name: 'bundle-chatWorker.[hash].js',
          },
        },
      },
    ],
  },
  plugins: [
    new StyleExtHtmlWebpackPlugin({
      position: 'head-bottom',
      chunks: ['index', 'upsell', 'chatEmbed'],
      minify: {
        level: {
          2: {
            all: true,
            overrideProperties: false,
          },
        },
      },
    }),
    new webpack.DefinePlugin({
      'process.env': {
        NODE_ENV: JSON.stringify('production'),
      },
    }),
    new webpack.LoaderOptionsPlugin({
      minimize: true,
      debug: false,
    }),
    new webpack.optimize.UglifyJsPlugin({
      compress: {
        unused: true,
        /* eslint camelcase: "off" */
        dead_code: true,
        warnings: false,
      },
    }),
  ],
});
