'use strict';

const process = require('process');
const path = require('path');
const webpackMerge = require('webpack-merge');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const nodeExternals = require('./workspaceSafeNodeExternals');

const commonConfig = require('./webpack.common');
const nonExternalModules = require('./nonExternalModules');

module.exports = webpackMerge(commonConfig, {
  name: 'lambda',
  target: 'node',
  externals: [
    nodeExternals({
      whitelist: nonExternalModules,
      modulesDirs: ['node_modules'],
    }),
  ],
  entry: './src/lambda/index.ts',
  output: {
    path: path.join(process.cwd(), 'dist/lambda'),
    library: 'index',
    libraryTarget: 'commonjs2',
    filename: 'index.js',
  },
  node: {
    __dirname: false,
    __filename: false,
  },
  plugins: [
    new CopyWebpackPlugin([
      { from: './dist/server/index.html', to: './index.html' },
      { from: './dist/server/chatEmbed.html', to: './chatEmbed.html' },
      { from: './build/translations/', to: './translations' },
    ]),
  ],
});
