'use strict';

const process = require('process');
const path = require('path');
const webpackMerge = require('webpack-merge');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const nodeExternals = require('./workspaceSafeNodeExternals');

const commonConfig = require('./webpack.common');
const nonExternalModules = require('./nonExternalModules');

module.exports = webpackMerge(commonConfig, {
  name: 'server',
  target: 'node',
  externals: [
    nodeExternals({
      whitelist: nonExternalModules,
      modulesDirs: ['node_modules', '../../node_modules'],
    }),
  ],
  entry: './src/server/devServer.tsx',
  output: {
    path: path.join(process.cwd(), '/dist/server'),
    filename: 'server.js',
  },
  node: {
    __dirname: false,
    __filename: false,
  },
  devtool: 'cheap-module-source-map',
  plugins: [
    new CopyWebpackPlugin([
      { from: './build/translations/', to: './translations' },
    ]),
  ],
});
