'use strict';

const path = require('path');
const webpackMerge = require('webpack-merge');
const nodeExternals = require('./workspaceSafeNodeExternals');

const commonConfig = require('./webpack.common');
const nonExternalModules = require('./nonExternalModules');

module.exports = webpackMerge(commonConfig, {
  name: 'test',
  target: 'node',
  externals: [
    nodeExternals({
      whitelist: nonExternalModules,
      modulesDirs: ['node_modules', '../../node_modules'],
    }),
  ],
  entry: './src/server/devServer.tsx',
  output: {
    path: path.join(process.cwd(), '/dist/test'),
    filename: 'server.js',
    devtoolModuleFilenameTemplate: '[absolute-resource-path]',
    devtoolFallbackModuleFilenameTemplate: '[absolute-resource-path]?[hash]',
  },
  devtool: 'cheap-module-source-map',
  resolve: {
    extensions: ['.webpack.js', '.web.js', '.ts', '.tsx', '.js'],
    modules: [process.cwd()],
  },
});
