// Karma configuration
// Generated on Sun Oct 02 2016 01:29:06 GMT-0500 (CDT)
var webpackConfig = require('./config/webpack.test.js');

module.exports = function(config) {
  config.set({
    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: '',

    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['expect', 'mocha'],

    // list of files / patterns to load in the browser
    // TODO: We are accidentally skipping .tsx files here, but that's okay until we figure out CSS importing
    files: [
      'test/*.ts',
      'test/**/*.ts',
      'test-karma/*.ts',
      'test-karma/**/*.ts',
    ],

    // list of files to exclude
    exclude: [
      'test/helpers/*.ts',
      'test/helpers/**/*.ts',
      // This would just be silly.
      'test/server/*.ts',
      'test/server/**/*.ts',
      'test/lambda/*.ts',
      'test/lambda/**/*.ts',
      // enzymify doesn't currently work/run in phantom because it needs to be transpiled
      'test/mocha-setup-test.ts',
    ],

    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
      'test/*.ts': ['webpack', 'sourcemap'],
      'test/**/*.ts': ['webpack', 'sourcemap'],
      'test-karma/*.ts': ['webpack', 'sourcemap'],
      'test-karma/**/*.ts': ['webpack', 'sourcemap'],
    },

    webpack: {
      module: webpackConfig.module,
      resolve: webpackConfig.resolve,
      externals: {
        'react/lib/ExecutionEnvironment': true,
        'react/addons': true,
        'react/lib/ReactContext': true,
      },
    },

    webpackMiddleware: {
      stats: 'errors-only',
    },

    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['progress', 'junit'],

    junitReporter: {
      outputDir: './test-results',
      suite: 'karma',
      useBrowserName: true,
    },

    // web server port
    port: 9876,

    // enable / disable colors in the output (reporters and logs)
    colors: true,

    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,

    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,

    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['PhantomJS'],

    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: false,

    // Concurrency level
    // how many browser should be started simultaneous
    concurrency: Infinity,

    mime: {
      'text/x-typescript': ['ts', 'tsx'],
    },
  });
};
