/* tslint:disable:no-namespace */

declare namespace AWS {
  namespace Lambda {
    interface ClientContext {
      installation_id: string;
      app_title: string;
      app_version_name: string;
      app_version_code: string;
      app_package_name: string;
    }

    interface Context<CustomType> {
      getRemainingTimeInMillis: () => number;
      callbackWaitsForEmptyEventLoop: boolean;
      functionName: string;
      functionVersion: string;
      invokedFunctionArn: string;
      memoryLimitInMB: number;
      awsRequestId: string;
      logGroupName: string;
      logStreamName: string;
      identity: any; // TODO: Research this.
      clientContext: {
        client: ClientContext | void;
        Custom: CustomType;
        env: {
          platform_version: string;
          platform: string;
          make: string;
          model: string;
          locale: string;
        };
      };
    }

    interface Callback<StateType> {
      (error: StateType, result: StateType): void;
    }
  }
}
