import * as expect from 'expect';
import { ReactElement } from 'react';

declare module 'expect' {
  export interface Expectation<T> extends expect.Expectation<T> {
    // augmentations
    toBeA(value: ReactElement<any> | string): Expectation<T>;
    toNotBeA(value: ReactElement<any> | string): Expectation<T>;
    toExist(): Expectation<T>;
    toNotExist(): Expectation<T>;
    toContain(value: ReactElement<any> | string): Expectation<T>;
    toNotContain(value: ReactElement<any> | string): Expectation<T>;

    // extensions
    toHaveProp(value: string, propValue?: any): Expectation<T>;
    toNotHaveProp(value: string, propValue?: any): Expectation<T>;
    toHaveProps(value: Object): Expectation<T>;
    toNotHaveProps(value: Object): Expectation<T>;
    toHaveClass(value: string): Expectation<T>;
    toNotHaveClass(value: string): Expectation<T>;
    toHaveState(value: Object): Expectation<T>;
    toNotHaveState(value: Object): Expectation<T>;
    toHaveRendered(value?: JSX.Element): Expectation<T>;
    toNotHaveRendered(value?: JSX.Element): Expectation<T>;
    toHaveStyle(value: string, styleValue?: string): Expectation<T>;
    toHaveStyle(value: Object): Expectation<T>;
    toNotHaveStyle(value: string, styleValue?: string): Expectation<T>;
    toNotHaveStyle(value: Object): Expectation<T>;
    toHaveContext(value: Object): Expectation<T>;
    toNotHaveContext(value: Object): Expectation<T>;
  }
}
