import { ValidationMap, ComponentState, Component } from 'react';

declare module 'react' {
  /**
   * This is a copy-paste of the definition of React.ComponentClass with
   * the addition of having the constructor return a broadened
   * React.Component. For some reason, TS doesn't like when you extend a
   * class and have its constructor return a different type.
   */

  export interface ExtendableComponentClass<P, E> {
    propTypes?: ValidationMap<P>;
    contextTypes?: ValidationMap<any>;
    childContextTypes?: ValidationMap<any>;
    defaultProps?: Partial<P>;
    displayName?: string;
    new (props?: P, context?: any): Component<P, ComponentState> & E;
  }
}
