/* tslint:disable:no-namespace */

declare namespace Twitch {
  type VideoId = string;
  type ChannelName = string;

  type EVENT_READY = 'ready';
  type EVENT_PLAY = 'play';
  type EVENT_PLAYING = 'playing';
  type EVENT_PAUSE = 'pause';
  type EVENT_ENDED = 'ended';
  type EVENT_ONLINE = 'online';
  type EVENT_OFFLINE = 'offline';
  type EVENT_TIMEUPDATE = 'timeupdate';
  type EVENT_PLAYING = 'playing';

  type ACCEPTABLE_CLIENT_APPS = 'mobile_web';

  type PlayerEvent =
    | EVENT_READY
    | EVENT_PLAY
    | EVENT_PLAYING
    | EVENT_PAUSE
    | EVENT_ENDED
    | EVENT_ONLINE
    | EVENT_OFFLINE
    | EVENT_TIMEUPDATE;

  interface BasePlayerOptions {
    height?: number | string;
    width?: number | string;
    branding?: boolean;
    channelInfo?: boolean;
    allowfullscreen?: boolean;
    playsinline?: boolean;
    autoplay?: boolean;
    muted?: boolean;
  }

  interface ChannelPlayerOptions extends BasePlayerOptions {
    channel?: ChannelName;
  }

  interface VODPlayerOptions extends BasePlayerOptions {
    video?: VideoId;
    time?: string;
  }

  interface TrackingProperties {
    app_session_id?: string;
    benchmark_session_id?: string;
    client_app?: ACCEPTABLE_CLIENT_APPS;
    content?: string;
    host_channel?: string;
    medium?: string;
    player?: string;
    referrer?: string;
    referrer_url?: string;
  }

  type PlayerOptions = ChannelPlayerOptions | VODPlayerOptions;

  class Player {
    public static READY: EVENT_READY;
    public static PLAY: EVENT_PLAY;
    public static PLAYING: EVENT_PLAYING;
    public static PAUSE: EVENT_PAUSE;
    public static ENDED: EVENT_ENDED;
    public static ONLINE: EVENT_ONLINE;
    public static OFFLINE: EVENT_OFFLINE;
    public static TIMEUPDATE: EVENT_TIMEUPDATE;

    constructor(ref: HTMLDivElement, options: PlayerOptions);
    public addEventListener(eventName: PlayerEvent, callback: Function): void;
    public isPaused(): boolean;
    public getCurrentTime(): number;
    public pause(): void;
    public play(): void;
    public removeEventListener(
      eventName: PlayerEvent,
      callback: Function,
    ): void;
    public seek(timestamp: number): void;
    public setChannel(channelName: ChannelName): void;
    public setVideo(videoID: VideoId): void;
    public setTrackingProperties(trackingProperties: TrackingProperties): void;
  }

  interface PlayerGlobal {
    READY: EVENT_READY;
    PLAY: EVENT_PLAY;
    PLAYING: EVENT_PLAYING;
    PAUSE: EVENT_PAUSE;
    ENDED: EVENT_ENDED;
    ONLINE: EVENT_ONLINE;
    OFFLINE: EVENT_OFFLINE;
    TIMEUPDATE: EVENT_TIMEUPDATE;
    new (ref: HTMLDivElement, options: PlayerOptions): Player;
  }
}
