import { Locale } from 'react-intl';
import { compose } from 'redux';

import { RootState } from 'mweb/common/reducers/root';

/* tslint:disable:no-namespace */

declare global {
  interface Window {
    __PRELOADED_STATE__: RootState;
    __REDUX_DEVTOOLS_EXTENSION_COMPOSE__: undefined | typeof compose;
    ReactIntlLocaleData: {
      [key: string]: Locale | Locale[];
    };
    Twitch: {
      Player: Twitch.PlayerGlobal;
    };
  }

  /**
   * Values the browser may provide for effective connection type.
   */
  enum EffectiveConnectionType {
    SecondGeneration = '2g',
    ThirdGeneration = '3g',
    FourthGeneration = '4g',
    SlowSecondGeneration = 'slow-2g',
  }

  /**
   * Values the browser may provide for connection type.
   */
  enum ConnectionType {
    Bluetooth = 'bluetooth',
    Cellular = 'cellular',
    Ethernet = 'ethernet',
    None = 'none',
    WiFi = 'wifi',
    WiMax = 'wimax',
    Other = 'other',
    Unknown = 'unknown',
  }

  /**
   * The Network Information API as defined by WICG.
   * http://wicg.github.io/netinfo/
   */
  interface NetworkInformation {
    /**
     * The currently observed download speed for this client.
     */
    downlink: number;
    /**
     * The maximum observed download speed for this client.
     */
    downlinkMax: number;
    /**
     * The effective network connection based on observed up/down/RTT.
     * This is in terms of cellular connections.
     */
    effectiveType: EffectiveConnectionType;
    /**
     * The currently observed Round Trip Time (RTT) for this client.
     */
    rtt: number;
    /**
     * The last hop network connection for this client.
     * For example, if a tablet is tethered to LTE via wifi this will be "wifi"
     * whereas if a cell phone is on LTE it will be "cellular". Use effectiveType
     * to get a category of performance.
     */
    type: ConnectionType;
  }

  /**
   * The fields provided by the global `navigator`.
   */
  interface Navigator {
    /**
     * The standard connection field.
     */
    connection: NetworkInformation;
    /**
     * Deprecated, Mozilla-specific network information.
     */
    mozConnection: NetworkInformation;
    /**
     * Deprecated, Chrome-specific network information.
     */
    webkitConnection: NetworkInformation;
  }

  type ScreenOrientationType =
    | 'portrait-primary'
    | 'portrait-secondary'
    | 'landscape-primary'
    | 'landscape-secondary';

  interface Screen {
    orientation:
      | {
          type: ScreenOrientationType;
        }
      | undefined;
  }
}
