require 'yaml'

class DriverConfig
  class << self
    def capabilities
      properties = get_config

      caps = {
        caps:
        {ENVIRONMENT: ENV['ENVIRONMENT'] || properties['ENVIRONMENT'],
         GRID: ENV['GRID'] || properties['GRID'].to_s,
         GRID_HOST: ENV['GRID_HOST'] || properties['GRID_HOST'],
         PLATFORM_NAME: ENV['PLATFORM_NAME'] || properties['PLATFORM_NAME'],
         PLATFORM_VERSION: ENV['PLATFORM_VERSION'] || properties['PLATFORM_VERSION'],
         DEVICE_NAME: ENV['DEVICE_NAME'] || properties['DEVICE_NAME'],
         BROWSER_NAME: ENV['BROWSER_NAME'] || properties['BROWSER_NAME'],
         AVD: ENV['ANV'] || properties['AVD'],
         RETRY_COUNT: ENV['RETRY_COUNT'] || properties['RETRY_COUNT']}
      }

      if properties.has_key?('AVD')
        caps[:caps][:AVD] = properties['AVD']
      end

      return caps
    end

    private def get_config
      config_path = File.read(File.expand_path('./core/configs/property_configs/config.yaml'))
      return YAML.load(config_path)
    end

    def env_android?
      capabilities[:caps][:PLATFORM_NAME].downcase == 'android'
    end

    def env_ios?
      capabilities[:caps][:PLATFORM_NAME].downcase == 'ios'
    end
  end
end
