module EnvConfig
  def initialize_environment
    case ENV['ENVIRONMENT']
      when 'local'
        puts "[INFO] Tests running on: #{local_host}"
        Capybara.app_host = local_host
      when 'staging'
        puts "[INFO] Tests running on: #{staging_host}"
        Capybara.app_host = staging_host
      when 'production', nil
        puts "[INFO] Tests running on: #{production_host}"
        Capybara.app_host = production_host
    else
        # Specify the URL in ENVIRONMENT
        puts "[INFO] Tests running on: #{ENV['ENVIRONMENT']}"
        Capybara.app_host = ENV['ENVIRONMENT']
    end
  end

  private def production_host
    return 'https://m.twitch.tv'
  end

  private def local_host
    return 'http://localhost:3003'
  end

  private def staging_host
    return 'https://staging.m.twitch.tv'
  end
end
