require 'yaml'

# properties_config.rb handles all YAML based
# configurations. Currently, only setup for video player
# parameters.
class PropertiesConfig
  @prop_conf = {} # Contains prooperties from property file
  @sys_conf = {} # Contains properties from the system (commandline/Jenkins)

  class << self
    attr_reader :prop_conf, :sys_conf

    def property_config(config_file)
      properties = YAML.load_file("./core/configs/property_configs/#{config_file}")

      # prop_conf is for properties managed from the Properties file
      @prop_conf[:ENVIRONMENT] = properties['ENVIRONMENT']
      @prop_conf[:GRID] = properties['GRID'] # parameter read as TrueClass
      @prop_conf[:GRID_HOST] = properties['GRID_HOST']
      @prop_conf[:PLATFORM_NAME] = properties['PLATFORM_NAME']
      @prop_conf[:PLATFORM_VERSION] = properties['PLATFORM_VERSION']
      @prop_conf[:DEVICE_NAME] = properties['DEVICE_NAME']
      @prop_conf[:BROWSER_NAME] = properties['BROWSER_NAME']
      @prop_conf[:AVD] = properties['AVD']
      @prop_conf[:RETRY_COUNT] = properties['RETRY_COUNT']

      # Sauce Labs
      @prop_conf[:SAUCELABS_USER] = properties['SAUCELABS_USER']
      @prop_conf[:SAUCELABS_KEY]  = properties['SAUCELABS_KEY']

      # sys_conf is for properties received via commandline / Jenkins
      @sys_conf[:ENVIRONMENT] = ENV['ENVIRONMENT']
      @sys_conf[:GRID] = ENV['GRID'] # parameter read as TrueClass
      @sys_conf[:GRID_HOST] = ENV['GRID_HOST']
      @sys_conf[:PLATFORM_NAME] = ENV['PLATFORM_NAME']
      @sys_conf[:PLATFORM_VERSION] = ENV['PLATFORM_VERSION']
      @sys_conf[:DEVICE_NAME] = ENV['DEVICE_NAME']
      @sys_conf[:BROWSER_NAME] = ENV['BROWSER_NAME']
      @sys_conf[:AVD] = ENV['AVD']
      @sys_conf[:RETRY_COUNT] = ENV['RETRY_COUNT']

      # Sauce Labs
      @sys_conf[:SAUCELABS_USER] = ENV['SAUCELABS_USER']
      @sys_conf[:SAUCELABS_KEY] = ENV['SAUCELABS_KEY']
    end
  end
end
