class ChannelPage
  @hosted_channel       = 'twitchmedia2'
  @hosting_channel      = 'qa_moba_host' # Test channel for host test cases. It will always host twitchmedia2
  @test_channel         = '/monstercat'

  @browse_channel_css = 'a.discover-more__channels'
  @browse_games_css   = 'a.discover-more__games'
  @channel_logo       = '.info-box--logo-container'
  @channel_metadata   = 'div.info-box--metadata'
  @chat_pane          = '.chat-pane'
  @chat_status        = 'li.chat-status'
  @iframe             = 'iframe'
  @info_box           = '.qa-info-box'
  @info_box_metadata  = '.qa-info-box--metadata'
  @loading_attr       = 'data-loading'
  @loading_icon_css   = 'div.pl-overlay--loading'
  @metadata_info      = 'div.info-box--metadata'
  @metadata_playing   = 'p.info-box--playing-info'
  @nav_container      = 'div.mw-top-nav__menu div.tw-balloon'
  @nav_icon           = 'div.mw-top-nav__menu button.tw-button-icon'
  @play_button        = '.js-control-play-button'
  @play_video_button  = 'button.player-button-play'
  @player             = '.player'
  @player             = 'div.player'
  @player_holder      = '.player-holder'
  @player_loader      = '.pl-overlay--loading'
  @switch_desktop_css = 'a.switch-to-desktop'
  @top_nav            = '.mw-top-nav'
  @top_nav_bar_css    = 'div.mw-top-nav'
  @twitch_logo_css    = 'svg.svg--logotwitch'
  class << self
    include Capybara::DSL

    attr_reader :browse_channel_css, :browse_games_css, :channel_logo, :channel_metadata, :chat_pane, :hosted_channel,
      :hosting_channel, :iframe, :loading_attr, :loading_icon_css, :metadata_info, :nav_icon, :play_button, :player,
      :player_holder, :player_loader, :player_loading, :switch_desktop_css, :top_nav, :top_nav_bar_css, :twitch_logo_css

    # @return [Capybara: Element] iframe of the player
    def player_frame
      within @player_holder do
        return find(@iframe)
      end
    end

    # @return [boolean] if the player is currently loading
    def player_loading?
      within_frame player_frame do
        return find(@player)[@loading_attr] == 'true'
      end
    end

    # @return [String] metdata information of the channel
    def info_box
      within @info_box do
        return @info_box_metadata
      end
    end

    # @return [String] chat status text
    def chat_status
      find(@chat_status).text
    end

    # @param [String] channel name
    def nav_to_channel(channel)
      visit "/#{channel}"
    end

    def has_text?(txt)
      within(@nav_container) do
        return page.has_text(txt)
      end
    end

    def play
      page.evaluate_script('player.play();')
    end

    # @return [String] metadata text of the channel
    def metadata_text
      find(@channel_metadata).text
    end

    # @return [String] metadata game of the channel
    def metadata_game_text
      find(@metadata_playing).text
    end

    # @return [String] status text of the chat
    def chat_status_text
      find(@chat_status).text
    end

    # @return [boolean] if the player has been loaded
    def has_player_loaded?
      within_frame player_frame do
        return page.has_selector?(@player)
      end
    end

    # Play the video
    def play_video
      within_frame player_frame do
        find(@play_video_button).click
      end
    end
  end
end
