class UpsellPage

  @upsell_page_div      = 'div.upsell-page'
  @twitch_logo_class    = 'svg.twitch-logo'
  @open_in_app_button   = 'div.open-in-app a.tw-button'
  @desktop_mode_button  = '.qa-decline_upsell'
  # rubocop:disable Metrics/LineLength
  @android_app_deeplink = 'intent://open?referrer=https%3A%2F%2Fm.twitch.tv%2Fupsell%2Fme#Intent;package=tv.twitch.android.app;scheme=twitch;S.market_referrer=utm_campaign%3Dmobile_upsell%26utm_source%3Dmwc;S.browser_fallback_url=market%3A%2F%2Fdetails%3Fid%3Dtv.twitch.android.app;end;'
  # rubocop:enable Metrics/LineLength
  @ios_app_deeplink     = 'https://u.m.twitch.tv/upsell/me?c=mobile_upsell-primary_button'

  class << self

    include Capybara::DSL

    attr_reader :open_in_app_button, :android_app_deeplink, :ios_app_deeplink

    # @return [boolean] if the current page is the upsell page
    def is_upsell_page?
      return page.has_selector?(@upsell_page_div)
    end

    # @return [boolean] if the page has twitch logo
    def has_twitch_logo?
      return page.has_selector?(@twitch_logo_class)
    end

    # @return [boolean] if the page has open_in_app_link
    def has_open_in_app_link?
      return find(@open_in_app_button).text.include?('Open in App')
    end

    # @return [boolean] if the page has switch_to_deskop_mode_link
    def has_switch_to_deskop_mode_link?
      return find(@desktop_mode_button).text.include?('Switch to Desktop Mode')
    end

    # @return [String] Current URL of the page after switching to desktop version
    def switch_to_desktop
      find(@desktop_mode_button).click
      page.has_text?('Browse channels') if DriverConfig.env_ios?
      return current_url
    end
  end
end
