class DirectoryPage

  @channel_image = '.card__img'
  @top_nav = '.mw-top-nav'
  @games_list = '.game-list'
  @channel_list = '.channel-list'

  @game_cards = '.card'
  @box_art = ".card__layout"
  @box_art_image = ".card__img"
  @card_body = ".card__body"
  @channel_game_name = ".card__bread"
  @channel_name = ".card__title"
  @channel_card_info = ".card__info"
  @game_url = '/directory/game/League%20of%20Legends'
  class << self

    include Capybara::DSL

    attr_reader :games_list, :top_nav, :box_art, :box_art_image, :game_cards,
      :channel_list, :channel_image

    def click_first_game
      first(@box_art).click
    end

    def navigate_to_channel_directory
      visit @game_url
    end

    def click_first_channel
      first(@box_art).click
    end

    # @param index [Integer] Index for which game title is to be returned
    # @return [String] Returns game title of the game based on index
    def box_art_game_title(index=0)
      return all(@box_art)[index].text
    end

    # @param url [String] Navigates to given url
    def navigate_to(url)
      visit "/#{url}"
    end

    # @return [Capybara::Result] Returns all the channel elements
    def box_art_games
      return all(@box_art)
    end

    # @return [Capybara::result] Returns an array of all the game cards
    def all_games
      return all(@game_cards)
    end

    # Creates and returns a hash containing info of the current channel
    # @return [Hash] Channel info - Game name, Channel name, viewers count
    def channel_info
      channel = {}
      channel[:game_name] = find(@channel_game_name, match: :first).text
      channel[:channel_name] = find(@channel_name, match: :first).text
      channel[:viewers] = find(@channel_card_info, match: :first).text.gsub(/[^0-9]/, '').to_i
      return channel
    end
  end
end
