class EventsPage
  @event_calendar_month = 'div.event-calendar__month span'
  @event_calendar_day   = 'div.event-calendar__day span'
  @header_image_css     = 'img.event-cover-image'
  @timespan_date_css    = 'span.timespan--date'
  @channel_css          = 'div.event-channel-info'
  @channel_logo_css     = 'div.event-channel-info img'
  @game_css             = 'div.event-game-info'
  @game_logo_css        = 'div.event-game-info img'
  @share_button_css     = '.event-actions-container button'
  @share_dock_items     = '.sharing-dock__item'
  @close_share_dock     = 'svg.svg-close'
  @description_css      = 'p.event-description'
  class << self

    include Capybara::DSL

    attr_reader :header_image_css, :timespan_date_css, :share_button_css
    # @return [boolean] if the page has a month between Jan to Dec
    def has_month?
      month = ['jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec']
      return month.include?(find(@event_calendar_month).text.downcase)
    end

    # @return [boolean] if the page has a day between 1 to 31
    def has_day?
      return find(@event_calendar_day).text.to_i.between?(1, 31)
    end

    # @return [boolean] if the timestamp date matches the regular expression
    def has_correct_timespan_date_format?(timespan_date_text)
      re1 = '((?:Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday|Tues|Thur|Thurs|Sun|Mon|Tue|Wed|Thu|Fri|Sat))' # Day Of Week 1
      re2 = '(,)' # Any Single Character 1
      re3 = '( )' # Any Single Character 2
      re4 = '((?:Jan(?:uary)?|Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May|Jun(?:e)?|Jul(?:y)?|Aug(?:ust)?|Sep(?:tember)?|
        Sept|Oct(?:ober)?|Nov(?:ember)?|Dec(?:ember)?))' # Month 1
      re5 = '( )' # Any Single Character 3
      re6 = '((?:(?:[0-2]?\\d{1})|(?:[3][01]{1})))(?![\\d])' # Day 1
      re7 = '( )' # Any Single Character 4
      re8 = '((?:(?:[0-1][0-9])|(?:[2][0-3])|(?:[0-9])):(?:[0-5][0-9])(?::[0-5][0-9])?(?:\\s?(?:am|AM|pm|PM))?)' # HourMinuteSec 1
      re9 = '( )' # Any Single Character 5
      re10 = '(-)'  # Any Single Character 6
      re11 = '( )'  # Any Single Character 7
      re12 = '((?:(?:[0-1][0-9])|(?:[2][0-3])|(?:[0-9])):(?:[0-5][0-9])(?::[0-5][0-9])?(?:\\s?(?:am|AM|pm|PM))?)' # HourMinuteSec 2

      re = (re1 + re2 + re3 + re4 + re5 + re6 + re7 + re8 + re9 + re10 + re11 + re12)
      m = Regexp.new(re, Regexp::IGNORECASE)
      return m.match(timespan_date_text)
    end

    # @return [boolean] if the page has the Twitch channel with its logo
    def has_channel_with_logo?
      channel_name = find(@channel_css).text.include?('Twitch')
      channel_logo = find(@channel_logo_css)[:src].include?('twitch')
      return channel_name && channel_logo
    end

    # @return [boolean] if the page has the Talk Shows game with its logo
    def has_game_with_logo?
      game_name = find(@game_css).text.include?('Talk Shows')
      game_logo = find(@game_logo_css)[:src].include?("Talk%20Shows")
      return game_name && game_logo
    end

    # Expands the share options
    def expand_share_options
      find(@share_button_css).click
    end

    # @return [Array] List of all items available in the share menu
    def share_dock_items_list
      return page.all(@share_dock_items).map { |item| item.text }
    end

    # Closes the share menu
    def close_share_dock_menu
      find(@close_share_dock).click
    end

    # @return [String] the description of the event
    def event_description_text
      return find(@description_css).text
    end
  end
end
