class ProfilePage

  @offline_toast_css = '.tw-toast'
  @top_nav = '.mw-top-nav'

  @header_text = '.pd-x-1 h5 span'
  @video_list_css = '.mw-channel-profile-video-list'
  @sub_videos_list_item_css = '.mw-channel-profile-video-card'
  @thumbnail_img = '.mw-channel-profile-video-card__image'
  @time = '.mw-channel-profile-video-card__time span.tw-stat__value'
  @videos_item_details = '.mw-channel-profile-video-card__details p.ellipsis'
  @show_more_link = '.tw-button'
  @broadcast_placeholder_css = '.tw-placeholder'

  @profile_avatar = '.mw-channel-info-card__avatar__image'
  @profile_expand_css = '.mw-channel-info-card svg.svg--plus'
  @profile_close_css = '.mw-channel-info-card svg.svg--close'
  @profile_stats = '.mw-channel-info-card div.tw-stat'
  @profile_description = '.mw-channel-info-card__details'
  @profile_red_indicator = '.mw-channel-info-card div.tw-live-indicator'
  @profile_indicator_status = 'div.mw-channel-info-card__body div.flex-nowrap'

  # Past broadcast elements
  @thumb_card = 'div.mw-featured-content-card'
  @thumb_title = 'div.mw-featured-content-card__details h5.ellipsis'
  @thumb_channel = 'div.mw-featured-content-card__details p.ellipsis'
  @thumb_image = 'div.mw-featured-content-card__image'
  @thumb_views = 'div.mw-featured-content-card__views span.tw-stat__value'
  @thumb_runtime = 'div.mw-featured-content-card__time span.tw-stat__value'
  @play_button = 'svg.svg--play'
  class << self

    include Capybara::DSL
    attr_reader :profile_expand_css, :profile_close_css, :profile_description, :profile_red_indicator, :profile_indicator_status

    attr_reader :show_more_link, :broadcast_placeholder_css, :videos

    attr_reader :offline_toast_css, :thumb_title, :thumb_channel, :thumb_image, :thumb_views, :thumb_runtime, :thumb_card

    attr_reader :play_button
    # @param url [String] URL to be navigated to
    def navigate_to(url)
      visit "/#{url}"
    end

    # @return [Capybara::Result] Array of profile stats
    def profile_stats
      return page.all(@profile_stats)
    end

    # @return [Integer] followers count using 'profile_stats' array
    def followers_count
      return profile_stats[0].text.to_i
    end

    # @return [Integer] viewers count using 'profile_stats' array
    def views_count
      return profile_stats[1].text.to_i
    end

    # @return [Boolean] True, if page has profile avatar
    def has_avatar?
      return page.has_css?(@profile_avatar)
    end

    # @return [Boolean] Returns True if page has offline toast
    def has_offline_toast?
      return page.has_css?(@offline_toast_css)
    end

    # @return [Boolean] Returns True if page has top nav
    def has_top_nav?
      return page.has_css?(@top_nav)
    end

    # @return [Boolean] If current url include /channelname/profile
    def on_profile_page?(channel)
      return page.current_url.include?("/#{channel}/profile")
    end

    # @return [Array] containing headers text
    def header_text
      return all(@header_text).map { |header| header.text }
    end

    # @param section_name [String] name of section
    # @return [Capybara::Node] div node
    def section_on_page(section_name)
      all_header_text = all(@header_text)
      all_header_text.each_with_index do |header, index|
        return all(@video_list_css)[index] if header.text.include? section_name
      end
    end

    # @param category [Capybara::Node] name of section
    # @return [Boolean] true if it has time, thumbnail_img and videos_item_details
    def entities_details(category)
      within(category) do
        all(@sub_videos_list_item_css).each do |items|
          within(items) do
            return (page.has_selector?(@thumbnail_img) and page.has_selector?(@time) and page.has_selector?(@videos_item_details))
          end
        end
      end
    end

    # @param category [Capybara::Node] name of section
    # @return [Integer] count of elements
    def videos_count(category)
      within(category) do
        return all(@sub_videos_list_item_css).size
      end
    end
  end
end
