module JSUtils

  def element_width(class_name)
    class_name = class_name[1..-1] if class_name[0] == '.'
    return Capybara.current_session.driver.browser.execute_script("return document.getElementsByClassName('#{class_name}')[0].offsetWidth")
  end

  def element_height(class_name)
    class_name = class_name[1..-1] if class_name[0] == '.'
    return Capybara.current_session.driver.browser.execute_script("return document.getElementsByClassName('#{class_name}')[0].offsetHeight")
  end

  def scroll_to(direction='bottom')
    if direction.to_s.downcase == 'bottom'
      scroll_script = 'window.scrollTo(0,document.body.scrollHeight);'
    else
      scroll_script = 'window.scrollTo(0,-document.body.scrollHeight);'
    end
    Capybara.current_session.driver.browser.execute_script(scroll_script)
  end
end
