require './core/configs/properties_config'
require './core/data/spec_data'
require './core/utils/twitch_utils'

class PropertiesConfigUtils
  PropertiesConfig.property_config(ENV['PROPERTIES'])
  def self.configure_environment
    environment = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:ENVIRONMENT]) ?
    PropertiesConfig.prop_conf[:ENVIRONMENT] : PropertiesConfig.sys_conf[:ENVIRONMENT]

    grid = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:GRID]) ?
    PropertiesConfig.prop_conf[:GRID] : PropertiesConfig.sys_conf[:GRID]

    grid_host = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:GRID_HOST]) ?
    PropertiesConfig.prop_conf[:GRID_HOST] : PropertiesConfig.sys_conf[:GRID_HOST]

    browser_name = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:BROWSER_NAME]) ?
    PropertiesConfig.prop_conf[:BROWSER_NAME] : PropertiesConfig.sys_conf[:BROWSER_NAME]

    platform_name = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLATFORM_NAME]) ?
    PropertiesConfig.prop_conf[:PLATFORM_NAME] : PropertiesConfig.sys_conf[:PLATFORM_NAME]

    platform_version = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLATFORM_VERSION]) ?
    PropertiesConfig.prop_conf[:PLATFORM_VERSION] : PropertiesConfig.sys_conf[:PLATFORM_VERSION]

    device_name = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:DEVICE_NAME]) ?
    PropertiesConfig.prop_conf[:DEVICE_NAME] : PropertiesConfig.sys_conf[:DEVICE_NAME]

    avd = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:AVD]) ?
    PropertiesConfig.prop_conf[:AVD] : PropertiesConfig.sys_conf[:AVD]

    retry_count = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:RETRY_COUNT]) ?
    PropertiesConfig.prop_conf[:RETRY_COUNT] : PropertiesConfig.sys_conf[:RETRY_COUNT]

    # Sauce Labs

    saucelabs_user = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:SAUCELABS_USER]) ?
    PropertiesConfig.prop_conf[:SAUCELABS_USER] : PropertiesConfig.sys_conf[:SAUCELABS_USER]

    saucelabs_key = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:SAUCELABS_KEY]) ?
    PropertiesConfig.prop_conf[:SAUCELABS_KEY] : PropertiesConfig.sys_conf[:SAUCELABS_KEY]

    SpecData.environment = environment
    SpecData.grid = grid.to_s
    SpecData.grid_host = grid_host
    SpecData.browser_name = browser_name.downcase
    SpecData.platform_name = platform_name
    SpecData.platform_version = platform_version
    SpecData.device_name = device_name
    SpecData.avd = avd
    SpecData.retry_count = retry_count

    # Sauce Labs

    SpecData.saucelabs_user = saucelabs_user
    SpecData.saucelabs_key  = saucelabs_key

    ENV['ENVIRONMENT'] = SpecData.environment
    ENV['GRID'] = SpecData.grid.to_s
    ENV['GRID_HOST'] = SpecData.grid_host
    ENV['BROWSER_NAME'] = SpecData.browser_name
    ENV['PLATFORM_NAME'] = SpecData.platform_name
    ENV['PLATFORM_VERSION'] = SpecData.platform_version
    ENV['DEVICE_NAME'] = SpecData.device_name
    ENV['AVD'] = SpecData.avd
    ENV['RETRY_COUNT'] = SpecData.retry_count.to_s

    ENV['SAUCELABS_USER'] = SpecData.saucelabs_user
    ENV['SAUCELABS_KEY'] = SpecData.saucelabs_key
  end
end
