#!/usr/bin/env bash

# This Script is Responsible for:
# 1) Running our Test Suite.
# 2) Provides Info of exit status of test-suite and created summy file if falied.

###################
#  Run the Suite  #
###################
source ~/.bashrc # Load any updated GITHUB_CREATOR variable from pre_notification_handler.sh
bundle exec rspec --format documentation
# Stores the exit code of the test suite, to ensure we exit out of this script with that exit code (near the bottom)
test_suite_exit_code=$?

# Creates dummy file if test suite failed
if [ $test_suite_exit_code != 0 ]; then
  echo "[INFO] TEST SUITE FAILED!!!. Test Suite exit code: $test_suite_exit_code"
  touch ./output/tests_failed
fi

# Exit the script with the exit code  of the test suite.
echo "[INFO] Preparing to exit initialization script. Test Suite exit code: $test_suite_exit_code"
