# UI testing with Appium

### Setup Appium Environment

##### XCode

Install latest [Xcode](https://developer.apple.com/xcode/downloads/) from app store.

Install [Xcode Command Line Tools](https://developer.apple.com/download/more/), or within Xcode: (Xcode > Preferences > Downloads).

##### Java

Install latest [Java](http://www.oracle.com/technetwork/java/javase/downloads/index.html).

##### Homebrew

Follow instructions at http://brew.sh/, copied below.

```shell
ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"
brew doctor
brew update && brew upgrade
```

Edit your path to prefer `/usr/local/bin` if it doesn't already by adding:

```shell
export PATH="/usr/local/bin":$PATH
```

to your `~/.bash_profile`. Alternatively: `echo 'export PATH="/usr/local/bin":$PATH' >> ~/.bash_profile`

##### Git

At the time of writing, the version of Git that came with OSX had a major [security vulnerability](https://github.com/blog/1938-vulnerability-announced-update-your-git-clients).

```shell
brew install git
```

##### Rbenv and ruby-build

```shell
brew install rbenv ruby-build
```

Add rbenv eval to your `~/.bash_profile`

```shell
echo 'eval "$(rbenv init -)"' >> ~/.bash_profile
```

Source your profile

```shell
source ~/.bash_profile
```

##### Install Ruby

We're currently running Ruby 2.3.0.

*NOTE:* You shouldn't run any of these commands with `sudo`. If you do, the following steps will break. Make sure to run these commands from within your moba directory.

```shell
rbenv install `cat .ruby-version`
rbenv rehash
```

Verify rbenv set the correct Ruby Version

```
ruby -v
```

##### Update RubyGems and Bundler.

```
gem update --system
gem install bundler -v 1.14.6
rbenv rehash
```

Check RubyGems is >= 2.1.5.

```
gem --version
```

##### Install Gems

`bundle install`

##### Install Other Dependencies

Install nodejs, using brew.
```
brew update
brew install node
```
Make sure you are using the correct node & npm version via `nvm use` in the project directory.

```
node --version
```

Install grunt.
```
npm install grunt
npm install -g grunt grunt-cli
```
Verify grunt and grunt-cli versions from the appium folder.
```
grunt --version
```

Install ant.
```
brew install ant
```
Install maven 3.1.1 or better.
```
brew install maven
```
Install Appium

```
npm install -g appium@1.6.4
```

Install Appium-Doctor
```
npm install -g appium-doctor
appium-doctor
```

Appium Doctor will check for Appium dependencies. Typically the user will need to set some of these
within their ~/.bash_profile. After this point in setup, we will likely have to set the following in
~/.bash_profile:

```
export JAVA_HOME="`/System/Library/Frameworks/JavaVM.framework/Versions/Current/Commands/java_home`"
export PATH=$PATH:$JAVA_HOME/bin
```

#### For setup reference:

http://appium.io/slate/en/tutorial/android.html?ruby#install-ruby

IDE for test case development:

[Rubymine IDE](https://www.jetbrains.com/ruby/)

[Atom] (https://atom.io/)

### Android env setup

##### Install Android SDK and Tools

[Download Android Studio](https://developer.android.com/studio/index.html)

Install Latest SDK and Tools

1) Open Android Studio

2) Click Configure > SDK Manager

3) Appearance & Behavior > System Settings > Android SDK

4) Select Latest Android version

5) Click SDK Tools

6) Make sure Intel x86 Emulator Accelerator is selected.

##### Create Android Virtual Device

1) Open Android Studio

2) Navigate to Tools > Android > AVD Manager

3) Create Virtual Device

4) Select a recent device > Next

5) Choose latest Android Version > Next

6) Select name for AVD and all other default settings > Finish

We will need to update our ~/.bash_profile here with the ANDROID_HOME, adb, android, emulator:
```
export ANDROID_HOME=/Users/<home_directory>/Library/Android/sdk
export ANDROID_SDK=$ANDROID_HOME

export PATH=$ANDROID_HOME/platform-tools:$PATH
export PATH=$ANDROID_HOME/tools:$PATH
```

### iOS env setup

##### Install Carthage
Web Driver Agent requires Carthage dependency manager

`brew install carthage`

##### Install iPhone Simulator

1) Open XCode

2) Navigate to Xcode -> Preferences -> Components

3) Download iOS Simulator 10.0 (or others)

### To Start Appium Server
Run
```
appium
```

### Helpful Docs
https://github.com/appium/ruby_lib/blob/master/docs/android_docs.md

http://appium.io/slate/en/v1.0.0/?ruby#appium-client-libraries

[Page Object Pattern] (http://www.assertselenium.com/automation-design-practices/page-object-pattern/)

## Writing Tests
Moba is written in Ruby, using RSpec, Capybara, Appium, and Selenium Webdriver

Generally we won't be actually talking with the Selenium Webdriver or Appium. Capybara includes
a very intuitive DSL.

- Use DOM explorer in desktop browser to grab css classes

For tests to be read by RSpec, the files should end in `_spec.rb`, such as `directory_spec.rb`, and
placed in the `spec` folder.

```
describe 'Channel Directory' do

  before(:each) do
    visit('/')
  end

  it 'loads via Games Directory' do
    expect(page).to have_css(DirectoryPage.games_list)

    first(DirectoryPage.directory_item_css).click
    expect(page).to have_css(DirectoryPage.channel_directory)
    expect(page).to have_css(DirectoryPage.directory_item_css)
  end
end
```

This code shows how to split features and scenarios, along with an example of a `before` hook.


## Configuration file and execution of code on saucelabs and local

### Sample Config File
```
ENVIRONMENT: production # [production, staging-qa-0, etc.]
GRID: true # [true when to run on saucelabs and false when to run on local]
GRID_HOST: saucelabs # [Only saucelabs is configured for now, so impact will be dependent on grid value to be true or false]
PLATFORM_NAME: Android # [Android, iOS]
PLATFORM_VERSION: '7.1' # ['7.1' for Android, '10.3' for iOS]
DEVICE_NAME: 'Android GoogleAPI Emulator' # [('Android GoogleAPI Emulator', 'iPhone Simulator') for saucelabs, (android) for local]
BROWSER_NAME: Chrome # [Chrome - Android, Safari - iOS]
AVD: moba_pixel
RETRY_COUNT: 5

SAUCELABS_USER: # DO NOT COMMIT CREDENTIALS
SAUCELABS_KEY: # DO NOT COMMIT CREDENTIALS
```
The above sample file is the version currently available on the master branch, which runs the test on saucelabs when run a branch with Jenkins.

The config parameters can be updated on the runtime by giving the paramter name with its value in the execution command

### Current command on Jenkins
### Android command
PROPERTIES=config.yaml SAUCELABS_USER=$SAUCELABS_USER SAUCELABS_KEY=$SAUCELABS_KEY bundle exec rspec

### iOS command
PROPERTIES=config.yaml PLATFORM_NAME='iOS' PLATFORM_VERSION='10.3' DEVICE_NAME='iPhone Simulator' BROWSER_NAME='Safari' SAUCELABS_USER=$SAUCELABS_USER SAUCELABS_KEY=$SAUCELABS_KEY bundle exec rspec

The large number of parameters in the iOS command is to change the parameter values as per the iOS enviornment

### Sample
PROPERTIES=config.yaml RETRY_COUNT=2 bundle exec rspec

or one can make changes directly to config file and run the below mentioned command:
PROPERTIES=config.yaml bundle exec rspec

### Running tests on local system emulator (Android)
* Make sure to install Android Studio in the local machine
* Create a Android Virtual Device with same name as the `AVD` in the config file

### Changes in the Config file for running test on local
```
GRID: false
GRID_HOST: local
```
