require './core/base/spec_helper'

describe 'Channel Page' do

  it 'can be accessed via directory' do # This should be moved to navigation spec in later commit

    visit '/'
    DirectoryPage.click_first_game # Games directory
    expect(page).to have_css(DirectoryPage.channel_list)
    expect(page).to have_css(DirectoryPage.box_art)

    DirectoryPage.click_first_channel # Channels directory
    expect(page).to have_css(ChannelPage.player_holder)
  end

  it 'shows channel being hosted' do
    skip('un-block deployment')
    visit "/#{ChannelPage.hosting_channel}" # Test channel qa_moba_host will always host twitchmedia2

    within ChannelPage.info_box do
      expect(page).to have_content(ChannelPage.hosting_channel + " hosting " + ChannelPage.hosted_channel)
    end
  end
end

describe 'Channel page player' do

  before(:each) do
    visit '/monstercat'
  end

  it 'loads' do
    skip('un-block deployment')
    within_frame(ChannelPage.player_frame) do
      find(ChannelPage.play_button).click
      expect(page).not_to have_css(ChannelPage.play_button)
    end
    expect(ChannelPage.player_loading?).to be true
  end
end
