require './core/base/spec_helper'

describe 'Channel page player' do

  let(:chat_message) { 'Welcome to the chat room!' }
  let(:txt) { 'Switch to Desktop Mode' }

  before(:each) do
    ChannelPage.nav_to_channel('monstercat')
  end

  it 'navigation is visible' do
    expect(page).to have_css(ChannelPage.top_nav)
  end

  it 'Channel Logo is shown' do
    expect(page).to have_css(ChannelPage.channel_logo)
  end

  it 'Channel Metata Data shows channel name' do
    expect(page).to have_css(ChannelPage.channel_metadata)
  end

  it 'Channel Metadata shows actions' do
    expect(page).to have_css(ChannelPage.metadata_info)
  end

  it 'Chat loads' do
    expect(page).to have_css(ChannelPage.chat_pane)
  end

  it 'Chat shows Welcome to the chat room' do
    expect(ChannelPage.chat_status).to eql(chat_message)
  end

  it 'Player loads' do
    skip('Iframe switching not supported in appium for iOS') if DriverConfig.env_ios?
    within_frame(ChannelPage.player_frame) do
      ChannelPage.play
    end
    expect(page).not_to have_css(ChannelPage.play_button)
  end

  it 'Player Plays stream' do
    skip('Iframe switching not supported in appium for iOS') if DriverConfig.env_ios?
    within_frame(ChannelPage.player_frame) do
      ChannelPage.play
    end
    expect(page).not_to have_css(ChannelPage.player_loader)
  end

  it 'Offline Channel shows "Switch to desktop mode" button' do
    find(ChannelPage.nav_icon).click
    expect(ChannelPage).to have_text(txt)
  end
end
