require './core/base/spec_helper'

describe 'Channels Directory' do
  let(:game_name) { 'League of Legends' }
  let(:game_url) { 'directory/game/League%20of%20Legends' }

  before(:each) do
    DirectoryPage.navigate_to game_url
  end

  it 'nav bar is visible' do
    expect(page).to have_css(DirectoryPage.top_nav)
  end

  it 'channel screenshot is visible' do
    expect(page).to have_css(DirectoryPage.box_art_image)
  end

  it 'channel screenshot includes game name, viewer count and channel name' do
    channel_data = DirectoryPage.channel_info
    expect(channel_data[:game_name]).to be_eql(game_name)
    expect(channel_data[:channel_name]).not_to be_nil
    expect(channel_data[:viewers]).to be > 0
  end

  it 'Phone shows 1 thunbnail per row' do
    channel_list_width = JSUtils.element_width(DirectoryPage.channel_list)
    channel_card_width = JSUtils.element_width(DirectoryPage.box_art_image)
    expect((channel_list_width / channel_card_width).to_i).to eq 1
  end

  it 'More games populate on scrolling down' do
    previous_channel_name = DirectoryPage.box_art_games.map { |game| game.text }
    JSUtils.scroll_to :bottom
    new_channel_name = DirectoryPage.box_art_games.map { |game| game.text }
    expect(previous_channel_name).not_to eql(new_channel_name)
  end

  it 'User is navigated to channel page on clicking a thumbnail' do
    DirectoryPage.all_games.first.click_on
    expect(page).to have_css(ChannelPage.player_holder, wait: 5)
  end
end
