require './core/base/spec_helper'
require './core/configs/driver_config'

describe 'Events page' do
  let(:event_path) { '/events/39623' }
  let(:page_title) { 'Twitch Weekly' }
  # rubocop:disable Metrics/LineLength
  let(:event_description) { 'Tune in to learn about new Twitch features, discover awesome streams and streamers, and hang out with hosts djWHEAT, AnnaProsser, Atrioc, and FishStix on this weekly talk show for the Twitch community. Stay tuned after for a Q&A with Ann Druyan (Co-Creator of COSMOS)' }
  # rubocop:enable Metrics/LineLength
  let(:expected_options) { ['Twitter', 'Reddit', 'Facebook', 'Copy'] }
  let(:expected_timestamp_date) { 'Friday, Apr 28 1:00 PM - 2:00 PM' }

  before(:each) do
    visit(event_path)
  end

  it 'has calendar widget in top left shows Month and Date in the two sections' do
    expect(EventsPage).to have_month
    expect(EventsPage).to have_day
  end

  it 'title is Twitch Weekly' do
    expect(page.title).to include(page_title)
  end

  it 'has top image' do
    expect(page).to have_selector(EventsPage.header_image_css)
  end

  it 'has correct timestamp format of the event' do
    expect(EventsPage).to have_correct_timespan_date_format(expected_timestamp_date)
  end

  it 'has twitch channel with logo' do
    expect(EventsPage).to have_channel_with_logo
  end

  it 'has talk shows game with logo' do
    expect(EventsPage).to have_game_with_logo
  end

  it 'has share button with social media options available' do
    expect(page).to have_selector(EventsPage.share_button_css)
    EventsPage.expand_share_options
    expect(expected_options).to be_eql(EventsPage.share_dock_items_list)
    EventsPage.close_share_dock_menu
  end

  it 'has event description' do
    expect(EventsPage.event_description_text).to be_eql(event_description)
  end
end
