require './core/base/spec_helper'

describe 'Games Directory' do
  before(:each) do
    visit('/')
  end

  it 'has a visible nav bar' do
    expect(page).to have_css(DirectoryPage.top_nav)
  end

  it 'has visible box art' do
    expect(page).to have_css(DirectoryPage.box_art)
    expect(page).to have_css(DirectoryPage.box_art_image)
  end

  it 'has titles on game selections' do
    expect(DirectoryPage.box_art_game_title[0]).not_to be_nil
  end

  it 'Phone portrait shows 2 games per row' do
    page.driver.browser.rotate :portrait
    game_list_width = JSUtils.element_width(DirectoryPage.games_list)
    game_card_width = JSUtils.element_width(DirectoryPage.game_cards)
    expect((game_list_width / game_card_width).to_i).to eq(2), "expected #{game_list_width} by #{game_card_width} to be equal 2"
  end

  it 'Phone landscape shows 4 games per row' do
    game_list_width_portrait = JSUtils.element_width(DirectoryPage.games_list)
    page.driver.browser.rotate :landscape
    WaitUtils.wait_until { game_list_width_portrait != JSUtils.element_width(DirectoryPage.games_list) }
    game_list_width_landscape = JSUtils.element_width(DirectoryPage.games_list)
    game_card_width = JSUtils.element_width(DirectoryPage.game_cards)
    expect((game_list_width_landscape / game_card_width).to_i).to eq(4), "expected #{game_list_width_landscape} by #{game_card_width} to be 4"
    page.driver.browser.rotate :portrait
  end

  it 'populates more games when scrolling down' do
    previous_games = DirectoryPage.all_games.each.map { |game| game.text }
    previous_games.sort!
    JSUtils.scroll_to :bottom
    new_games = DirectoryPage.all_games.each.map { |game| game.text }
    new_games.sort!
    expect(previous_games).not_to eql(new_games)
  end

  it 'takes a user to the channel directory when a game is clicked' do
    DirectoryPage.all_games.first.click_on
    expect(page).to have_css(DirectoryPage.channel_list)
  end

  after(:each) do
    page.driver.browser.rotate :portrait
  end
end
