require './core/base/spec_helper'
require './core/configs/driver_config'

describe 'Live-To-VOD: ' do
  let(:ltv_live_path) { '/streams/26461201120/channel/27446517' }
  let(:channel_name) { 'Monstercat' }
  let(:playing_field) { 'Playing Music' }
  let(:chat_status_text) { 'Welcome to the chat room!' }

  before(:each) do
    visit(ltv_live_path)
  end

  it 'Page has a top nav bar' do
    expect(page).to have_selector(ChannelPage.top_nav)
  end

  it 'Page has twitch logo' do
    expect(page).to have_selector(ChannelPage.twitch_logo_css)
  end

  it 'Metadata contains channel name and what is playing' do
    expect(ChannelPage.metadata_text).to include(channel_name)
    expect(ChannelPage.metadata_game_text).to be_eql(playing_field)
  end

  it "Chat includes text 'Welcome to the chat room!'" do
    expect(ChannelPage.chat_status_text).to be_eql(chat_status_text)
  end

  it 'Page has player' do
    skip "Frame switching unsupported in iOS" if DriverConfig.env_ios?
    expect(ChannelPage).to have_player_loaded
  end

  it 'video is playing' do
    skip "Frame switching unsupported in iOS" if DriverConfig.env_ios?
    ChannelPage.play_video
    # Can take time to start playback
    within_frame ChannelPage.player_frame do
      expect(page).not_to have_selector(ChannelPage.player_loader, wait: 20)
    end
  end
end
