require './core/base/spec_helper'
require './core/configs/driver_config'

describe 'Live-To-VOD for VOD Stream: ' do
  let(:ltv_live_path) { '/streams/13842044576/channel/27446517' }
  let(:channel_name) { 'Monstercat' }
  let(:playing_field) { 'Monstercat Showcase: Grabbitz' }
  let(:browse_channel_text) { 'Browse all other channels!' }
  let(:browse_games_text) { 'Browse all other games!' }
  let(:switch_desktop_text) { 'Switch to Desktop Mode' }

  before(:each) do
    visit(ltv_live_path)
  end

  it 'Page has a top nav bar' do
    expect(page).to have_selector(ChannelPage.top_nav)
  end

  it 'Page has twitch logo' do
    expect(page).to have_selector(ChannelPage.twitch_logo_css)
  end

  it 'Metadata contains channel name and what is playing' do
    skip('Metadata information inconsistent for Monstercat')
    # TODO: Change channel information after getting a consistent link
    expect(ChannelPage.metadata_text).to include(channel_name)
    expect(ChannelPage.metadata_game_text).to be_eql(playing_field)
  end

  it 'Page has player' do
    skip "Frame switching unsupported in iOS" if DriverConfig.env_ios?
    expect(ChannelPage).to have_player_loaded
  end

  it 'video is playing' do
    skip "Frame switching unsupported in iOS" if DriverConfig.env_ios?
    ChannelPage.play_video
    # Can take time to start playback
    within_frame ChannelPage.player_frame do
      expect(page).not_to have_selector(ChannelPage.loading_icon_css, wait: 20)
    end
  end

  it "Page has 'Browse all other channels!' button" do
    expect(page).to have_selector(ChannelPage.browse_channel_css)
    expect(find(ChannelPage.browse_channel_css).text).to be_eql(browse_channel_text)
  end

  it "Page has 'Browse all other games!' button" do
    expect(page).to have_selector(ChannelPage.browse_games_css)
    expect(find(ChannelPage.browse_games_css).text).to be_eql(browse_games_text)
  end

  it "Page has 'Switch to Desktop Mode' button" do
    expect(page).to have_selector(ChannelPage.switch_desktop_css)
    expect(find(ChannelPage.switch_desktop_css).text).to be_eql(switch_desktop_text)
  end
end
