require './core/base/spec_helper'

describe 'Offline channel' do

  let(:offline_channel) { 'qa_auto_offline' }

  before(:each) do
    ProfilePage.navigate_to offline_channel
  end

  it 'url redirects to profile page.' do
    expect(ProfilePage.on_profile_page?(offline_channel)).to be_truthy
  end

  it 'has toast that says channel is offline' do
    expect(ProfilePage).to have_offline_toast
  end

  it 'has nav bar' do
    expect(ProfilePage).to have_top_nav
  end

end

describe 'Offline channel profile card' do

  let(:offline_channel) { 'qa_auto_offline' }

  before(:each) do
    ProfilePage.navigate_to offline_channel
  end

  it 'is collapsed.' do
    expect(page).to have_css(ProfilePage.profile_expand_css)
  end

  it 'has followers count.' do
    expect(ProfilePage.followers_count).not_to be_nil
  end

  it 'has views count.' do
    expect(ProfilePage.views_count).not_to be_nil
  end

  it 'has avatar.' do
    expect(ProfilePage).to have_avatar
  end

  it 'changes button state on expanding profile card.' do
    find(ProfilePage.profile_expand_css).click
    expect(page).not_to have_css(ProfilePage.profile_expand_css)
    expect(page).to have_css(ProfilePage.profile_close_css)
  end

  it 'description is displayed on expansion.' do
    find(ProfilePage.profile_expand_css).click
    expect(page).to have_css(ProfilePage.profile_description)
  end
end

describe 'Profile Page of offline channel' do

  let(:array_of_header) { ["qa_auto_moba's Clips", "qa_auto_moba's Highlights"] }
  let(:clips) { ProfilePage.section_on_page('Clips') }
  let(:highlights) { ProfilePage.section_on_page('Highlights') }
  let(:show_clips_btn) { 'Show more clips' }
  let(:show_highlights_btn) { 'Show more highlights' }
  let(:offline_moba_channel) { 'qa_auto_moba' }

  before(:each) do
    ProfilePage.navigate_to offline_moba_channel
  end

  it 'Does not shows placeholder if has no broadcasts but has clips/highlights' do
    expect(page).not_to have_css(ProfilePage.broadcast_placeholder_css)
  end

  it 'verify headers' do
    skip('BUG : MWC-380')
    expect(ProfilePage.header_text).to match_array(array_of_header)
  end

  it 'verify 3 entries, should have a thumbnail, runtime overlayed and title, game on left' do
    skip('BUG : MWC-380')
    # Clips
    expect(clips).not_to be_nil
    expect(ProfilePage.videos_count(clips)).to eql(3)
    expect(ProfilePage.entities_details(clips)).to be_truthy

    # Highlights
    expect(highlights).not_to be_nil
    expect(ProfilePage.videos_count(highlights)).to eql(3)
    expect(ProfilePage.entities_details(highlights)).to be_truthy
  end

  it 'verify the show more button shows three more and disappears' do
    skip('BUG : MWC-380')
    # Clips
    expect(clips).not_to be_nil
    click_on show_clips_btn
    within(clips) do
      expect(page).not_to have_css(ProfilePage.show_more_link)
    end
    expect(ProfilePage.videos_count(clips)).to eql(6)

    # Highlights
    expect(highlights).not_to be_nil
    click_on show_highlights_btn
    within(highlights) do
      expect(page).not_to have_css(ProfilePage.show_more_link)
    end
    expect(ProfilePage.videos_count(highlights)).to eql(6)
  end
end
