require './core/base/spec_helper'

describe 'Channel navigation when channel is online' do
  let(:online_channel) { 'monstercat' }

  before(:each) do
    ProfilePage.navigate_to online_channel
  end

  it 'URL does not redirects to profile page' do
    expect(ProfilePage.on_profile_page?(online_channel)).to be_falsy
  end

  it 'does not show up that says channel is offline' do
    expect(ProfilePage).not_to have_offline_toast
  end

  it 'has nav bar state' do
    expect(ProfilePage).to have_top_nav
  end
end

describe 'Online channel profile card' do
  let(:online_channel_profile) { 'monstercat/profile' }

  before(:each) do
    ProfilePage.navigate_to online_channel_profile
  end

  it 'has pulsing red Live indicator' do
    expect(page).to have_css(ProfilePage.profile_red_indicator)
    expect(find(ProfilePage.profile_indicator_status).text).to include('LIVE')
  end

  it 'is collapsed.' do
    expect(page).to have_css(ProfilePage.profile_expand_css)
  end

  it 'has followers count.' do
    expect(ProfilePage.followers_count).not_to be_nil
  end

  it 'has views count.' do
    expect(ProfilePage.views_count).not_to be_nil
  end

  it 'has avatar.' do
    expect(ProfilePage).to have_avatar
  end

  it 'changes button state on expanding profile card.' do
    find(ProfilePage.profile_expand_css).click
    expect(page).not_to have_css(ProfilePage.profile_expand_css)
    expect(page).to have_css(ProfilePage.profile_close_css)
  end

  it 'description is displayed on expansion.' do
    find(ProfilePage.profile_expand_css).click
    expect(page).to have_css(ProfilePage.profile_description)
  end
end

describe 'Profile Page of online channel' do
  let(:array_of_header) { ["Monstercat's Recent Highlights", "Monstercat's Top Clips"] }
  let(:clips) { ProfilePage.section_on_page('Clips') }
  let(:highlights) { ProfilePage.section_on_page('Highlights') }
  let(:show_clips_btn) { 'Show more clips' }
  let(:show_highlights_btn) { 'Show more highlights' }

  before(:each) do
    ProfilePage.navigate_to('monstercat/profile')
  end

  it 'Does not shows broadcast placeholder if only have clips/highlights' do
    expect(page).not_to have_css(ProfilePage.broadcast_placeholder_css)
  end

  it 'verify headers' do
    expect(ProfilePage.header_text).to match_array(array_of_header)
  end

  it 'verify 3 entries should have thumbnail, runtime and title, game on left' do
    # Clips
    expect(clips).not_to be_nil
    expect(ProfilePage.videos_count(clips)).to eql(3)
    expect(ProfilePage.entities_details(clips)).to be_truthy

    # Highlights
    expect(highlights).not_to be_nil
    expect(ProfilePage.videos_count(highlights)).to eql(3)
    expect(ProfilePage.entities_details(highlights)).to be_truthy
  end

  it 'verify the show more button shows three more and disappears' do
    # Clips
    expect(clips).not_to be_nil
    click_on show_clips_btn
    within(clips) do
      expect(page).not_to have_css(ProfilePage.show_more_link)
    end
    expect(ProfilePage.videos_count(clips)).to eql(6)

    # Highlights
    expect(highlights).not_to be_nil
    click_on show_highlights_btn
    within(highlights) do
      expect(page).not_to have_css(ProfilePage.show_more_link)
    end
    expect(ProfilePage.videos_count(highlights)).to eql(6)
  end
end

describe 'Profile page with past broadcast' do
  let(:online_channel_food_profile) { 'food/profile' }
  let(:header) { 'Most recent broadcast' }

  before(:each) do
    visit online_channel_food_profile
  end

  it "has 'Most recent broadcast' header" do
    expect(page).to have_text(header)
  end

  it 'tile has thumbnail, title, number of views, runtime and channel name' do
    expect(find(ProfilePage.thumb_title).text).not_to be_nil
    expect(find(ProfilePage.thumb_views).text).not_to be_nil
    expect(find(ProfilePage.thumb_channel).text).not_to be_nil
    expect(find(ProfilePage.thumb_runtime).text).not_to be_nil
    expect(find(ProfilePage.thumb_card).text).not_to be_nil
  end

  it 'clip has a play button' do
    expect(page).to have_selector(ProfilePage.play_button)
  end
end
