require './core/base/spec_helper'
require './core/configs/driver_config'

describe 'Upsell' do
  let(:upsell_path) { '/upsell/me' }
  let(:upsell_text) { 'Watch and chat with your favorite broadcasters.' }

  before(:each) do
    visit(upsell_path)
  end

  it 'page is displayed' do
    expect(UpsellPage.is_upsell_page?).to be_truthy
  end

  it 'page show upsell pitch text' do
    expect(page).to have_text(upsell_text)
  end

  it 'page shows twitch image' do
    expect(UpsellPage).to have_twitch_logo
  end

  it 'page has Open in app link button' do
    expect(UpsellPage).to have_open_in_app_link
  end

  it 'page has Switch to desktop mode link' do
    expect(UpsellPage).to have_switch_to_deskop_mode_link
  end

  it 'to app has correct href' do
    expect(page).to have_css(UpsellPage.open_in_app_button)
    if DriverConfig.env_ios?
      expect(page).to have_link('Open in App', href: UpsellPage.ios_app_deeplink)
    elsif DriverConfig.env_android?
      expect(page).to have_link('Open in App', href: UpsellPage.android_app_deeplink)
    end
  end

  it 'declined - correctly loads desktop site' do
    www_url = 'https://www.twitch.tv' + upsell_path + '?no-mobile-redirect=true'
    go_url = 'https://go.twitch.tv' + upsell_path + '?no-mobile-redirect=true'
    expect([www_url, go_url]).to include(UpsellPage.switch_to_desktop)
  end
end
