# src

The `src` directory is split into four pieces:
* `common/`
* `server/`
* `client/`
* `lambda/`

## common

The common directory contains code that _can_ (but not necessarily _is_)
executed both on the server and client (this is the universal code).

## server

The server directory consists of code specific to the dev server or code
that is shared between dev & production server.

## client

The client directory consists of code that should only ever execute on the
client. It also includes the HTML files for the various client entry points.

## lambda

The lambda director consists of code that should only ever execute inside of
the lambda. It is of the **utmost** importance that this code is kept
intentionally minimal. In fact, anyone modifything this file should assume that
at some point all of their code will be rolled into another folder and should
find a way to _either_ add it to `server` or `common` (`common` is better).
