import { ChatEvent } from 'mweb/chat/events/baseChatEvent';

export const CHAT_MESSAGES_UPDATED = 'CHAT_MESSAGES_UPDATED';
interface ChatMessagesUpdatedAction {
  type: typeof CHAT_MESSAGES_UPDATED;
  payload: {
    messages: any;
  };
}

export const CHAT_RESET = 'CHAT_RESET';
interface ChatResetAction {
  type: typeof CHAT_RESET;
}

export const CHAT_EMBED_INITIALIZED = 'CHAT_EMBED_INITIALIZED';
interface ChatEmbedInitializedAction {
  type: typeof CHAT_EMBED_INITIALIZED;
  payload: {
    theme: string;
    fontSize: string;
  };
}

export type ChatAction =
  | ChatMessagesUpdatedAction
  | ChatResetAction
  | ChatEmbedInitializedAction
  | { type: 'NOOP' };

export function chatUpdateMessages(
  messages: ReadonlyArray<ChatEvent>,
): ChatMessagesUpdatedAction {
  return {
    type: CHAT_MESSAGES_UPDATED,
    payload: {
      messages,
    },
  };
}

export function chatReset(): ChatResetAction {
  return {
    type: CHAT_RESET,
  };
}

export function chatInitializeEmbed(
  theme: string,
  fontSize: string,
): ChatEmbedInitializedAction {
  return {
    type: CHAT_EMBED_INITIALIZED,
    payload: {
      theme,
      fontSize,
    },
  };
}
