import {
  ChatAction,
  CHAT_MESSAGES_UPDATED,
  CHAT_RESET,
  CHAT_EMBED_INITIALIZED,
} from 'mweb/chat/chatAction';
import { ChatEvent } from 'mweb/chat/events/baseChatEvent';

export interface ChatEmbedOptions {
  theme?: string;
  fontSize?: string;
}

export interface ChatState {
  messages: ReadonlyArray<ChatEvent>;
  embedOptions?: ChatEmbedOptions;
}

export const DEFAULT_CHAT_STATE: ChatState = {
  messages: [],
  embedOptions: undefined,
};

export function chat(
  state: ChatState = DEFAULT_CHAT_STATE,
  action: ChatAction,
): ChatState {
  switch (action.type) {
    case CHAT_MESSAGES_UPDATED:
      return {
        ...state,
        messages: action.payload.messages,
      };
    case CHAT_EMBED_INITIALIZED:
      return {
        ...state,
        embedOptions: action.payload,
      };
    case CHAT_RESET:
      return DEFAULT_CHAT_STATE;
    default:
      return state;
  }
}
