import { UserStatePayload } from 'mweb/chat/chatClient';
import { Badge } from 'mweb/chat/badgerService';
import {
  createMessageData,
  MessageData,
} from 'mweb/chat/events/utils/createMessageData';
import idCreator from 'mweb/chat/events/utils/idCreator';

export const POST = 'POST';
export const ACTION = 'ACTION';
export type MessageEventType = typeof POST | typeof ACTION;

export interface MessageEvent extends MessageData {
  type: MessageEventType;
  id: string;
}

export function messageEvent(
  type: MessageEventType,
  message: string,
  userstate: UserStatePayload,
  badges: Badge[],
): MessageEvent {
  return {
    ...createMessageData(message, userstate, badges),
    type,
    id: userstate.id || idCreator(`${userstate.username}-msg`),
  };
}
