import idCreator from 'mweb/chat/events/utils/idCreator';

export const BAN = 'BAN';
export const TIMEOUT = 'TIMEOUT';

export type ModerationEventType = typeof BAN | typeof TIMEOUT;

export interface ModerationEvent {
  type: ModerationEventType;
  id: string;
  username: string;
  reason: string | null;
  duration: number;
}

export function moderationEvent(
  type: ModerationEventType,
  username: string,
  reason: string | null,
  duration?: number,
): ModerationEvent {
  return {
    type,
    id: idCreator(`${username}-mod`),
    username,
    reason,
    duration: duration || 0,
  };
}
