import idCreator from 'mweb/chat/events/utils/idCreator';

export const CONNECTED = 'CONNECTED';
export const DISCONNECTED = 'DISCONNECTED';
export const RECONNECT = 'RECONNECT';
export const HOSTING = 'HOSTING';
export const UNHOST = 'UNHOST';

export type ConnectionStatusEventType =
  | typeof CONNECTED
  | typeof DISCONNECTED
  | typeof RECONNECT;

export type HostingStatusEventType = typeof HOSTING | typeof UNHOST;

export type StatusEventType =
  | ConnectionStatusEventType
  | HostingStatusEventType;

export interface ConnectedEvent {
  type: typeof CONNECTED;
  id: string;
}

export interface DisconnectedEvent {
  type: typeof DISCONNECTED;
  id: string;
  reason: string | undefined;
}

export interface ReconnectEvent {
  type: typeof RECONNECT;
  id: string;
}

export interface HostingEvent {
  type: typeof HOSTING;
  id: string;
  channel: string;
  hostedChannel: string;
}

export interface UnhostEvent {
  type: typeof UNHOST;
  id: string;
  channel: string;
}

export type ConnectionStatusEvent =
  | ConnectedEvent
  | DisconnectedEvent
  | ReconnectEvent;

export type HostingStatusEvent = HostingEvent | UnhostEvent;

export type StatusEvent = ConnectionStatusEvent | HostingStatusEvent;

export function connectedEvent(): ConnectedEvent {
  return {
    type: CONNECTED,
    id: idCreator('connected'),
  };
}

export function disconnectedEvent(reason: string): DisconnectedEvent {
  return {
    type: DISCONNECTED,
    id: idCreator('disconnected'),
    reason,
  };
}

export function reconnectEvent(): ReconnectEvent {
  return {
    type: RECONNECT,
    id: idCreator('reconnect'),
  };
}

export function hostingEvent(
  channel: string,
  hostedChannel: string,
): HostingEvent {
  return {
    type: HOSTING,
    id: idCreator('hosting'),
    channel,
    hostedChannel,
  };
}

export function unhostEvent(channel: string): UnhostEvent {
  return {
    type: UNHOST,
    id: idCreator('unhost'),
    channel,
  };
}
